function sumMatrix = plus(mat1,mat2)
%PLUS This function overloads the '+' operator for AdjacencyMatrix objects,
%so that the adjacency matrix returned represents the sum of the two
%adjacency matrices

newRowLabs = mat1.rowLabels;

newColumnLabs = mat1.columnLabels;

% Check to see if any row and column labels exist in mat2 but not in mat1
for i = 1:numel(mat2.rowLabels)
    if ~any(strcmp(newRowLabs,mat2.rowLabels{i}))
        newRowLabs = [newRowLabs ; mat2.rowLabels{i}];
    end
end
for i = 1:numel(mat2.columnLabels)
    if ~any(strcmp(newColumnLabs,mat2.columnLabels{i}))
        newColumnLabs = [newColumnLabs mat2.columnLabels{i}];
    end
end

%Start out with mat1.A as a base
newMat = mat1.A;

%Resize, padding with zeros so it is the size of the final matrix
newMat = [newMat zeros(size(newMat,1),numel(newColumnLabs)-size(newMat,2))];
newMat = [newMat ; zeros(numel(newRowLabs)-size(newMat,1),size(newMat,2))];

% Loop through non-zero elements of mat2.A, adding them to newMat
[ii,jj] = find(mat2.A);
for kk = 1:numel(ii)
    r = find(strcmp(newRowLabs,mat2.rowLabels(ii(kk))));
    c = find(strcmp(newColumnLabs,mat2.columnLabels(jj(kk))));
    newMat(r,c) = newMat(r,c) + mat2.A(ii(kk),jj(kk));
end


% Old implementation, super-slow
% for i = 1:numel(newRowLabs)
%     for j = 1:numel(newColumnLabs)
%         try
%             newMat(i,j) = newMat(i,j)+subsref(mat2,struct('type','()','subs',{{newRowLabs{i} newColumnLabs{j}}}));
%         catch exception
%             % in this case we could not find the element in newColumnLabs
% %             disp([newRowLabs{i} ' to ' newColumnLabs{j}])
%             continue
%         end
%     end
% end
sumMatrix = AdjacencyMatrix(newMat,newRowLabs,newColumnLabs,'matrixType',[mat1.matrixType ' + ' mat2.matrixType]);         
end